package com.Rokato.jni_demo;

import android.util.Log;

import com.Rokato.jni.rf.ICpuCardReader;
import com.Rokato.jni.rf.RfReader;
import com.Rokato.jni.utils.Convert;

public class CpuImpl implements ICpuCardReader {

    public static final String TAG = "Rokato_CpuImpl";//adb logcat -s Rokato_:V

    private final RfReader rfReader;

    CpuImpl(RfReader rfReader) {
        assert (rfReader != null);
        this.rfReader = rfReader;
    }

    @Override
    public boolean reqCard(boolean idle, byte[] cardNo, byte[] type) {
        Log.d(TAG, "reqCard");
        return rfReader.reqCard(idle, cardNo, type);
    }

    @Override
    public int cpuReset(byte[] cardNo, byte[] ats) {
        Log.d(TAG, "cpuReset");
        return rfReader.cpuReset(cardNo, ats);
    }

    @Override
    public byte[] cpuSend(final byte[] apdu) {
        Log.d(TAG, "cpuSend:" + Convert.bytesToHexStr(apdu));
        final byte[] ret = rfReader.cpuSend(apdu);
        Log.d(TAG, "resp:" + Convert.bytesToHexStr(ret));
        return ret;
    }

    @Override
    public boolean cpuHalt() {
        Log.d(TAG, "cpuHalt");
        return rfReader.cpuHalt();
    }

    @Override
    public boolean rfHalt() {
        Log.d(TAG, "rfHalt");
        return rfReader.rfHalt();
    }

}
