package com.Rokato.jni_demo;

import android.util.Log;

import com.Rokato.jni.rf.IM1CardReader;
import com.Rokato.jni.rf.RfReader;

public class M1Impl implements IM1CardReader {

    public static final String TAG = "Rokato_M1Impl";//adb logcat -s Rokato_:V

    private final RfReader rfReader;

    M1Impl(RfReader rfReader) {
        assert (rfReader != null);
        this.rfReader = rfReader;
    }

    @Override
    public boolean reqCard(boolean idle, byte[] cardNo, byte[] type) {
        Log.d(TAG, "reqCard");
        return rfReader.reqCard(idle, cardNo, type);
    }

    @Override
    public boolean rfSelect(final byte[] cardNo, byte[] sak) {
        Log.d(TAG, "rfSelect");
        return rfReader.rfSelect(cardNo, sak);
    }

    @Override
    public boolean m1Auth(short sector, final byte[] pwd, boolean keyB) {
        Log.d(TAG, "m1Auth");
        return rfReader.m1Auth(sector, pwd, keyB);
    }

    @Override
    public boolean m1Read(short block, byte[] buff) {
        Log.d(TAG, "m1Read");
        return rfReader.m1Read(block, buff);
    }

    @Override
    public boolean m1Write(short block, final byte[] buff) {
        Log.d(TAG, "m1Write");
        return rfReader.m1Write(block, buff);
    }

    @Override
    public boolean rfHalt() {
        Log.d(TAG, "rfHalt");
        return rfReader.rfHalt();
    }
}
