package com.Rokato.jni_demo;

import androidx.appcompat.app.AppCompatActivity;

import android.annotation.SuppressLint;

import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;

import com.Rokato.jni.Rokato;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class MainActivity extends AppCompatActivity {
    //adb shell setprop debug.checkjni 1
    private boolean isInit = false;

    @SuppressLint("SetTextI18n")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        Button allTestBtn = findViewById(R.id.allTest_button);
        allTestBtn.setOnClickListener(v -> {
            if (!isInit) isInit = Rokato.init();
            if (isInit)
                new Thread(new MyThread(this)).start();
        });

        Button mfToolBtn = findViewById(R.id.mfTool_button);
        mfToolBtn.setOnClickListener(v -> {
            if (!isInit) isInit = Rokato.init();
            if (isInit) {
                Intent intent = new Intent(this, MfToolActivity.class);
                startActivity(intent);
            }
        });

        Button cpuToolBtn = findViewById(R.id.cpuTool_button);
        cpuToolBtn.setOnClickListener(v -> {
            if (!isInit) isInit = Rokato.init();
            if (isInit) {
                Intent intent = new Intent(this, CpuToolActivity.class);
                startActivity(intent);
            }
        });

        Button usbToolBtn = findViewById(R.id.usbTool_button);
        usbToolBtn.setOnClickListener(v -> {
            if (!isInit) isInit = Rokato.init();
            if (isInit) {
                Intent intent = new Intent(this, UsbToolActivity.class);
                startActivity(intent);
            }
        });

        Button hidToolBtn = findViewById(R.id.hidTool_button);
        hidToolBtn.setOnClickListener(v -> {
            if (!isInit) isInit = Rokato.init();
            if (isInit) {
                Intent intent = new Intent(this, HidToolActivity.class);
                startActivity(intent);
            }
        });

        Button serialToolBtn = findViewById(R.id.serialTool_button);
        serialToolBtn.setOnClickListener(v -> {
            if (!isInit) isInit = Rokato.init();
            if (isInit) {
                Intent intent = new Intent(this, SerialToolActivity.class);
                startActivity(intent);
            }
        });
    }

    public static void addLog(EditText logEdit, String tag, String msg) {
        if (tag.length() > 500) {
            tag = tag.substring(0, 500);
            tag += "...";
        }
        if (msg.length() > 500) {
            msg = msg.substring(0, 500);
            msg += "...";
        }
        final Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        final String times = String.format(Locale.US, "%02d:%02d:%02d->", c.get(Calendar.HOUR_OF_DAY), c.get(Calendar.MINUTE), c.get(Calendar.SECOND));
        String log = logEdit.getText().insert(0, times + tag + '\n' + msg + '\n').toString();
        if (log.length() > 10000) {
            log = log.substring(0, 6000);
            log += "...";
        }
        logEdit.setText(log);
    }
}

