package com.Rokato.jni_demo;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.util.Log;

import com.Rokato.jni.Rokato;

import com.Rokato.jni.utils.UsbUtils;
import com.Rokato.jni.utils.Convert;

import com.Rokato.jni.comm.UsbComm;
import com.Rokato.jni.comm.HidComm;
import com.Rokato.jni.comm.SerialPort;

import com.Rokato.jni.rf.CosErr;
import com.Rokato.jni.rf.CpuCard;
import com.Rokato.jni.rf.M1Card;
import com.Rokato.jni.rf.NfcReader;
import com.Rokato.jni.rf.RfReader;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Arrays;

public class MyThread extends Thread {
    public static final String TAG = "Rokato_Demo";//adb logcat -s Rokato_:V

    private final Activity activity;
    private final Context ctx;
    @SuppressLint("StaticFieldLeak")
    private static NfcReader nfc = null;

    MyThread(Activity activity) {
        this.activity = activity;
        this.ctx = activity.getApplicationContext();
        if (nfc == null) nfc = new NfcReader(this.ctx);
    }

    @Override
    public void run() {
        UsbUtils usbUtils = new UsbUtils(ctx, null);

        Log.d(TAG, "Rokato_jni 接口测试开始");
        Log.d(TAG, "Rokato version " + Rokato.version());
        Log.d(TAG, "Rokato build " + Rokato.build());

        Log.d(TAG, "SerialPort 对象测试");
        String json = SerialPort.enumPorts();
        Log.d(TAG, "SerialPort enumPorts=" + json);
        if (json != null) {
            try {
                JSONArray jsonObj = new JSONArray(json);
                for (int i = 0; i < jsonObj.length(); ++i) {
                    JSONObject portObj = jsonObj.getJSONObject(i);
                    Log.d(TAG, "idx=" + i + ",addr=" + portObj.getString("addr") + ",desc=" + portObj.getString("desc") + ",devId=" + portObj.getString("devId"));
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        SerialPort serialPort = new SerialPort(0, 200);
        Log.d(TAG, "SerialPort setAddr " + serialPort.setAddr("/dev/ttyS3"));
        Log.d(TAG, "SerialPort getAddr " + serialPort.getAddr());
        Log.d(TAG, "SerialPort setBaudrate " + serialPort.setBaudrate(115200));
        Log.d(TAG, "SerialPort getBaudrate " + serialPort.getBaudrate());
        Log.d(TAG, "SerialPort setTimeout " + serialPort.setTimeout(200, 1));
        Log.d(TAG, "SerialPort open " + serialPort.open());
        Log.d(TAG, "SerialPort isOpen " + serialPort.isOpen());
        Log.d(TAG, "SerialPort purgeRead " + serialPort.purgeRead());
        Log.d(TAG, "SerialPort purgeWrite " + serialPort.purgeWrite());
        Log.d(TAG, "SerialPort purge " + serialPort.purge());
        Log.d(TAG, "SerialPort available " + serialPort.available());

        byte[] data = new byte[1024];
        int len = serialPort.read(data);
        Log.d(TAG, "SerialPort read " + len + " data " + Convert.bytesToHexStr(data, len));
        len = serialPort.write(data, data.length);
        Log.d(TAG, "SerialPort write " + len);
        serialPort.close();
        Log.d(TAG, "SerialPort free " + serialPort.free());

        Log.d(TAG, "UsbComm 对象测试");
        UsbComm usbComm = new UsbComm(ctx);
        Log.d(TAG, "UsbComm open " + usbComm.open(usbUtils.find(0x1A86, 0x7523), 0));
        Log.d(TAG, "UsbComm isOpen " + usbComm.isOpen());
        Log.d(TAG, "UsbComm setCH340 " + usbComm.setCH340(2400, 10));
        Log.d(TAG, "UsbComm setUSBSerialControllerD " + usbComm.setUSBSerialControllerD(2400, 10));
        Log.d(TAG, "UsbComm setFT232Uart " + usbComm.setFT232Uart(2400, 10, 2));
        Log.d(TAG, "UsbComm setCH9329Cfg " + usbComm.setCH9329Cfg(0x1A86, 0xE129, (short) 3, (short) 2, 2400, (short) 0, 10));
        Log.d(TAG, "UsbComm setConfig " + usbComm.setConfig(0));
        Log.d(TAG, "UsbComm getConfig " + usbComm.getConfig());
        Log.d(TAG, "UsbComm releaseInterface " + usbComm.releaseInterface(0));
        Log.d(TAG, "UsbComm claimInterface " + usbComm.claimInterface(0));
        Log.d(TAG, "UsbComm setInterfaceAlternate " + usbComm.setInterfaceAlternate(0, 0));

        len = usbComm.bulkTransfer((byte) 0x82, data, data.length, 5000);
        Log.d(TAG, "UsbComm bulkTransfer recv " + len + " data " + Convert.bytesToHexStr(data, len));
        if (len > 0) {
            len = usbComm.bulkTransfer((byte) 0x02, data, len, 200);
            Log.d(TAG, "UsbComm bulkTransfer send " + len);
        }

        len = usbComm.interruptTransfer((byte) 0x82, data, data.length, 5000);
        Log.d(TAG, "UsbComm interruptTransfer recv " + len + " data " + Convert.bytesToHexStr(data, len));
        if (len > 0) {
            len = usbComm.interruptTransfer((byte) 0x02, data, len, 200);
            Log.d(TAG, "UsbComm interruptTransfer send " + len);
        }
        Log.d(TAG, "UsbComm controlTransfer " + usbComm.controlTransfer((byte) 0, (byte) 0, (short) 0, (short) 0, null, 200));
        Log.d(TAG, "UsbComm clearHalt " + usbComm.clearHalt((byte) 0x02));
        Log.d(TAG, "UsbComm resetDevice " + usbComm.resetDevice());
        usbComm.close();
        Log.d(TAG, "UsbComm free " + usbComm.free());

        Log.d(TAG, "HidComm 对象测试");
        HidComm hidComm = new HidComm(ctx);
        Log.d(TAG, "HidComm open " + hidComm.open(usbUtils.find(0x1A86, 0xE010), 0));
        Log.d(TAG, "HidComm isOpen " + hidComm.isOpen());
        Log.d(TAG, "HidComm setCH9326 " + hidComm.setCH9326(2400));

        len = hidComm.read(data, 2000);
        Log.d(TAG, "HidComm read " + len + " data " + Convert.bytesToHexStr(data, len));
        if (len > 0) {
            len = hidComm.write(data, len);
            Log.d(TAG, "HidComm write " + len);
        }
        len = hidComm.sendFeatureReport(data, len);
        Log.d(TAG, "HidComm sendFeatureReport " + len);
        len = hidComm.getFeatureReport(data, 2000);
        Log.d(TAG, "HidComm getFeatureReport " + len + " data " + Convert.bytesToHexStr(data, len));
        len = hidComm.getInputReport(data, 2000);
        Log.d(TAG, "HidComm getInputReport " + len + " data " + Convert.bytesToHexStr(data, len));
        hidComm.close();
        Log.d(TAG, "HidComm free " + hidComm.free());


        Log.d(TAG, "RfReader 对象测试");
        Log.d(TAG, "UsbUtils hasReader DevType_HC_HID " + usbUtils.hasReader(RfReader.DevType_HC_HID));
        Log.d(TAG, "UsbUtils hasReader DevType_YZ_CH9326 " + usbUtils.hasReader(RfReader.DevType_YZ_CH9326));
        Log.d(TAG, "UsbUtils hasReader DevType_MU_HID " + usbUtils.hasReader(RfReader.DevType_MU_HID));
        Log.d(TAG, "UsbUtils hasReader DevType_CU_CH340 " + usbUtils.hasReader(RfReader.DevType_CU_CH340));

        RfReader rfReader = new RfReader(usbUtils, RfReader.DevType_AUTO, RfReader.RfType_ISO14443A);
        Log.d(TAG, "RfReader DevType_YZ_SERIAL serialCfg " + rfReader.serialCfg(RfReader.DevType_YZ_SERIAL, "/dev/ttyS3"));
        Log.d(TAG, "RfReader DevType_CU_SERIAL serialCfg " + rfReader.serialCfg(RfReader.DevType_CU_SERIAL, "/dev/ttyUSB10"));
        Log.d(TAG, "RfReader getDevType " + rfReader.getDevType());
        Log.d(TAG, "RfReader setRfType " + rfReader.setDevType(RfReader.DevType_AUTO));
        Log.d(TAG, "RfReader getRfType " + rfReader.getRfType());
        Log.d(TAG, "RfReader open " + rfReader.open());
        Log.d(TAG, "RfReader setRfType " + rfReader.setRfType(RfReader.RfType_ISO14443A));
        rfReader.close();
        Log.d(TAG, "RfReader ping " + rfReader.ping(true));
        Log.d(TAG, "RfReader getVer " + rfReader.getVer());
        Log.d(TAG, "RfReader led " + rfReader.led((byte) 1, (byte) 1));
        Log.d(TAG, "RfReader beep " + rfReader.beep((byte) 15));
        Log.d(TAG, "RfReader rfReset " + rfReader.rfReset());
        byte[] cardNo = new byte[4];
        byte[] type = new byte[2];
        Log.d(TAG, "RfReader reqCard " + rfReader.reqCard(false, cardNo, type));
        Log.d(TAG, "RfReader cardNo=" + Convert.getCardNoStr(cardNo) + " type=" + Convert.bytesToHexStr(type) + " typeStr=" + RfReader.typeStr(type));
        byte[] sak = new byte[1];
        Log.d(TAG, "RfReader rfSelect " + rfReader.rfSelect(cardNo, sak));
        Log.d(TAG, "RfReader sak=" + Convert.bytesToHexStr(sak));
        Log.d(TAG, "RfReader rfHalt " + rfReader.rfHalt());

        if (!nfc.hasOpen()) {
            if (!nfc.bind(activity, tag -> {
                nfc.setNewTag(tag);
                nfc.active();
                Log.d(TAG, "M1Card 对象系统NFC读卡器测试");
                M1Card m1 = new M1Card(nfc);
                workM1(m1);
                Log.d(TAG, "M1Card free=" + m1.free());

                Log.d(TAG, "CpuCard 对象系统NFC读卡器测试");
                CpuCard cpu = new CpuCard(nfc);
                workCPU(cpu);
                Log.d(TAG, "CpuCard free=" + cpu.free());
            })) {
                Log.d(TAG, "绑定NFC被动回调异常失败！");
            } else if (nfc.open()) {
                Log.d(TAG, "开启NFC被动读卡测试完成");
            } else {
                Log.d(TAG, "NFC读卡器不可用,请检查系统NFC开关与授权后再试！");
            }
        } else {
            nfc.close();
            Log.d(TAG, "停止NFC被动读卡测试完成");
        }

        Log.d(TAG, "CpuCard 对象内置读卡器测试");
        CpuCard cpuCard = new CpuCard(rfReader);
        workCPU(cpuCard);
        Log.d(TAG, "CpuCard free=" + cpuCard.free());

        Log.d(TAG, "CpuCard 对象自定义读卡器测试");
        cpuCard = new CpuCard(new CpuImpl(rfReader));
        workCPU(cpuCard);
        Log.d(TAG, "CpuCard free=" + cpuCard.free());

        Log.d(TAG, "M1Card 对象静态方法测试");
        Log.d(TAG, "M1Card makeCtl=" + Convert.bytesToHexStr(M1Card.makeCtl(M1Card.M1_KEY_DEFAULT, M1Card.M1_KEY_DEFAULT, M1Card.M1_POWER_DEFAULT)));
        byte[] power = M1Card.M1_POWER_DEFAULT_PRO;
        Log.d(TAG, "M1Card parsePowerStr=" + M1Card.parsePowerStr(power));
        Log.d(TAG, "M1Card dumpPowerStr=" + M1Card.dumpPowerStr("000|000|000|001", power));
        Log.d(TAG, "M1Card power=" + Convert.bytesToHexStr(power));


        Log.d(TAG, "M1Card 对象内置读卡器测试");
        M1Card m1Card = new M1Card(rfReader);
        workM1(m1Card);
        Log.d(TAG, "M1Card free=" + m1Card.free());
        Log.d(TAG, "M1Card 对象自定义读卡器测试");
        m1Card = new M1Card(new M1Impl(rfReader));
        workM1(m1Card);
        Log.d(TAG, "M1Card free=" + m1Card.free());
        Log.d(TAG, "RfReader free=" + rfReader.free());

        Log.d(TAG, "Rokato_jni 接口测试结束");
    }

    public void workM1(M1Card m1Card) {
        byte[] type = new byte[2];
        byte[] sak = new byte[1];
        Log.d(TAG, "M1Card reset " + m1Card.reset(false, type, sak));
        Log.d(TAG, "M1Card cardNo=" + m1Card.cardNo() + " type=" + Convert.bytesToHexStr(type) + " sak=" + Convert.bytesToHexStr(sak) + " typeStr=" + RfReader.typeStr(type));
        byte[] data = new byte[M1Card.M1_SECTOR_BLOCK_NUM * M1Card.M1_BLOCK_SIZE];
        byte[] blockData = new byte[M1Card.M1_BLOCK_SIZE];
        int err;
        m1Card.protect(true, true);
        for (byte sector = 0; sector < M1Card.M1_SECTOR_NUM; ++sector) {
            Arrays.fill(data, (byte) 0);
            err = m1Card.read(true, sector, M1Card.M1_KEY_DEFAULT, data, (byte) 0, (byte) 0, false, true);
            Log.d(TAG, "M1Card 扇区" + sector + " 读取" + M1Card.errStr(err));
            if (err > 0) {
                for (byte block = 0; block < M1Card.M1_SECTOR_BLOCK_NUM; ++block) {
                    System.arraycopy(data, block * M1Card.M1_BLOCK_SIZE, blockData, 0, blockData.length);
                    Log.d(TAG, "M1Card 扇区" + sector + " 块" + block + "=" + Convert.bytesToHexStr(blockData));
                }
            }
            data[16] = '1';
            err = m1Card.write(true, sector, M1Card.M1_KEY_DEFAULT, data, (byte) 0, (byte) 4, false);
            Log.d(TAG, "M1Card 扇区" + sector + " 写入" + M1Card.errStr(err));
        }
        Log.d(TAG, "M1Card halt=" + m1Card.halt());
    }

    public void workCPU(CpuCard cpuCard) {
        byte[] type = new byte[2];
        Log.d(TAG, "CpuCard reset " + cpuCard.reset(false, type));
        Log.d(TAG, "CpuCard type= " + Convert.bytesToHexStr(type) + " typeStr=" + RfReader.typeStr(type));
        Log.d(TAG, "CpuCard cardNo=" + cpuCard.cardNo() + " cosCode=" + cpuCard.cosCode() + " cosVer=" + cpuCard.cosVer() + " atsBuf=" + Convert.bytesToHexStr(cpuCard.atsBuf()));
        Log.d(TAG, "CpuCard atsStr=" + cpuCard.atsStr());
        //示例SELECT_FILE 1PAY.SYS.DDF01 测试
        final byte[] apdu = Convert.hexStrToBytes("00A404000E315041592E5359532E4444463031");
        final byte[] resp = cpuCard.send(apdu);
        Log.d(TAG, "CpuCard send resp" + Convert.bytesToHexStr(resp));
        Log.d(TAG, "CosErr SW=" + CosErr.getStr(CosErr.cosDataSW(resp)));
        Log.d(TAG, "CpuCard halt=" + cpuCard.halt());
    }
}
